/****** Object:  StoredProcedure [dbo].[P_LOJA_NOVA]    Script Date: 10/07/2012 18:09:10 ******/
IF EXISTS (
		SELECT *
		FROM sys.objects
		WHERE object_id = OBJECT_ID(N'[dbo].[P_LOJA_NOVA]')
			AND type IN (N'P', N'PC')
		)
	DROP PROCEDURE [dbo].[P_LOJA_NOVA]
GO

--EXEC P_LOJA_NOVA  1,35
--Procedure para replicar cadastro complementar de produtos e preos
CREATE PROCEDURE [dbo].[P_LOJA_NOVA] (
	@IN_CD_FILIAL_BASE INT = 1
	,@IN_CD_FILIAL_DESTINO INT = 1
	)
AS
SET DEADLOCK_PRIORITY high;
SET NOCOUNT ON;

--Replicando produtos complemento
ALTER TABLE dbo.EST_PROD_CPL DISABLE CHANGE_TRACKING;

INSERT INTO EST_PROD_CPL (
	CD_EMP
	,CD_FILIAL
	,CD_PROD
	,QT_EST
	,QT_EST_FLUT
	,PRAT
	,GAV
	,VLR_CUSTO_MD
	,VLR_CUSTO
	,QT_IMP
	,DT_IMP
	,SLD_INI
	,VLR_CUSTO_INI
	,CD_USU
	,DT_ULT_ATU
	,VLR_CONS
	,VLR_REV
	,PERC_IPI
	,IPI_NF_SAIDA
	,TP_PROD
	,STS_PROD
	,DT_CAD
	,VLR_CUSTO_ANT
	,VLR_CUSTO_TAB
	,DT_ULT_ENTR_COMPRA
	,VLR_COMPRA
	,DT_ULT_ENTR_TRANSF
	,VLR_TRANSF
	,QTDE_PONTO_FIDEL
	,EMAX
	,ESEG
	,CD_SIGLA
	,QT_EST_EM_TERC
	,QT_EST_DE_TERC
	,QT_EST_GAV
	,QTDE_FINANCIADO
	,QTDE_LIMITADOR
	,QTDE_FACEAMENTO
	,MEDIAF
	,QT_VD_MES1
	,QT_VD_MES2
	,QT_VD_MES3
	,PERC_DESC_FIDEL
	,PERC_DESC_FIDEL_MAX
	,PERC_COMISSAO_SERVICO
	,QT_EST_DEPOSITOS
	,QTDE_MES_VENDA_FECHADO
	,PERC_COMIS
	,FLAG_VERBA_DESCON
	,PERC_DESC_LIMITE
	,VLR_FABRICA
	,DT_ATUALIZA_PARAM
	)
SELECT p.CD_EMP
	,@IN_CD_FILIAL_DESTINO AS CD_FILIAL
	,p.CD_PROD
	,0 AS QT_EST
	,0 AS QT_EST_FLUT
	,p.PRAT
	,p.GAV
	,0 AS VLR_CUSTO_MD
	,0 AS VLR_CUSTO
	,0 AS QT_IMP
	,NULL AS DT_IMP
	,0 AS SLD_INI
	,0 AS VLR_CUSTO_INI
	,1 AS CD_USU
	,NULL AS DT_ULT_ATU
	,0 AS VLR_CONS
	,0 AS VLR_REV
	,p.PERC_IPI
	,p.IPI_NF_SAIDA
	,p.TP_PROD
	,p.STS_PROD
	,GETDATE() AS DT_CAD
	,0 AS VLR_CUSTO_ANT
	,0 AS VLR_CUSTO_TAB
	,NULL AS DT_ULT_ENTR_COMPRA
	,0 AS VLR_COMPRA
	,NULL AS DT_ULT_ENTR_TRANSF
	,0 AS VLR_TRANSF
	,p.QTDE_PONTO_FIDEL
	,p.EMAX
	,p.ESEG
	,0 AS CD_SIGLA
	,0 AS QT_EST_EM_TERC
	,0 AS QT_EST_DE_TERC
	,0 AS QT_EST_GAV
	,0 AS QTDE_FINANCIADO
	,0 AS QTDE_LIMITADOR
	,0 AS QTDE_FACEAMENTO
	,0 AS MEDIAF
	,0 AS QT_VD_MES1
	,0 AS QT_VD_MES2
	,0 AS QT_VD_MES3
	,p.PERC_DESC_FIDEL
	,p.PERC_DESC_FIDEL_MAX
	,p.PERC_COMISSAO_SERVICO
	,0 AS QT_EST_DEPOSITOS
	,0 AS QTDE_MES_VENDA_FECHADO
	,p.PERC_COMIS
	,p.FLAG_VERBA_DESCON
	,p.PERC_DESC_LIMITE
	,p.VLR_FABRICA
	,NULL
FROM EST_PROD_CPL p WITH (NOLOCK)
LEFT OUTER JOIN EST_PROD_CPL CPL WITH (NOLOCK) ON p.CD_EMP = CPL.CD_EMP
	AND @IN_CD_FILIAL_DESTINO = CPL.CD_FILIAL
	AND p.CD_PROD = CPL.CD_PROD
WHERE p.CD_EMP = 1
	AND p.CD_FILIAL = @IN_CD_FILIAL_BASE
	AND CPL.CD_PROD IS NULL;

ALTER TABLE dbo.EST_PROD_CPL ENABLE CHANGE_TRACKING
	WITH (TRACK_COLUMNS_UPDATED = ON);

--Replicando preos
ALTER TABLE dbo.EST_PROD_PRECO DISABLE CHANGE_TRACKING;

INSERT INTO EST_PROD_PRECO (
	CD_EMP
	,CD_FILIAL
	,CD_CTR
	,CD_PROD
	,VLR_TABELA
	,VLR_OFERTA
	,DT_CAD
	,CD_USU
	,STS_PRECO
	,VLR_CUSTO
	,PERC_ICMS
	,PERC_IMP
	,PERC_COMIS
	,PERC_DESP
	,PERC_MARGEM
	,STS_IMP_ETQ_GOND
	,VLR_TABELA_ANT
	,VLR_OFERTA_ANT
	,VLR_CUSTO_GER
	)
SELECT p.CD_EMP
	,@IN_CD_FILIAL_DESTINO AS CD_FILIAL
	,p.CD_CTR
	,p.CD_PROD
	,p.VLR_TABELA
	,p.VLR_OFERTA
	,p.DT_CAD
	,p.CD_USU
	,p.STS_PRECO
	,p.VLR_CUSTO
	,p.PERC_ICMS
	,p.PERC_IMP
	,p.PERC_COMIS
	,p.PERC_DESP
	,p.PERC_MARGEM
	,p.STS_IMP_ETQ_GOND
	,p.VLR_TABELA_ANT
	,p.VLR_OFERTA_ANT
	,0 VLR_CUSTO_GER
FROM EST_PROD_PRECO p WITH (NOLOCK)
LEFT OUTER JOIN EST_PROD_PRECO preco WITH (NOLOCK) ON p.CD_EMP = preco.CD_EMP
	AND @IN_CD_FILIAL_DESTINO = preco.CD_FILIAL
	AND p.CD_PROD = preco.CD_PROD
WHERE p.CD_EMP = 1
	AND p.CD_FILIAL = @IN_CD_FILIAL_BASE
	AND preco.CD_PROD IS NULL;

ALTER TABLE dbo.EST_PROD_PRECO ENABLE CHANGE_TRACKING
	WITH (TRACK_COLUMNS_UPDATED = ON);
